/* $Id: PACKET.C 1.4 1999/01/10 07:20:24 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/SRC/RCS/PACKET.C $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

/* Assumes Turbo C large model */

#pragma inline

#include <stdio.h>
#include <dos.h>

#include "config.h"
#include "windat.h"
#include "protocol.h"

/* #define XDEBUG  1  */
/* #define CONSOLE_VERBOSE 1 */

int     ip_handle,arp_handle,rarp_handle,have_handles;
extern int     slip_mode;              /* set if slip connection */
int     rarp_mode;

extern unsigned char stat;                    /* status from last read */
extern char *bufpt,*bufend,*bufread,*buforg;
extern int bufbig,buflim;
static int packet_vector;                       /* non-zero if we found it */

#define IC_ANY  	 0
#define IC_ETHERNET     1
#define IC_SLIP         6
#define IC_PPP		15
#define IT_ANY		0xFFFF

#define BAD_TYPE        5

extern	void far	pkt_receiver();
static  int     oldvec;

struct packet_info {
        int     packet_version;
        int     packet_class;
        int     packet_type;
        int     packet_ifnumber;
        char far *packet_name;
        int     packet_extended;
};

#ifdef  XDEBUG
bios_report(char *s)
{
	int	x;
	union REGS regs;

	for(x=0; *(s+x); x++) {
        	regs.x.ax = 0x0e00;
	        regs.x.bx = 7;
		regs.h.al = *(s + x);
		int86(0x10, &regs, &regs);
	}

}
#endif

/* UM */
static int which_class(void)	 /* return the class of driver this is */
			 /* or -1 if failure */
{
   union REGS regs;
   struct SREGS segregs;

   if(!packet_vector)
		return(-1);
	regs.x.ax = (1*256+255);  /* ah=1 al=255 */
	regs.x.bx = 0;	 /* no handle */
	int86x(packet_vector,&regs,&regs,&segregs);
	if(regs.x.cflag) {
		char	buff[512];
#ifdef	CXDEBUG
		sprintf(buff,"Packet driver_info Error %d\n\r",regs.h.dh);
		n_puts(buff);
#endif
		return(-1);
	  }	/* end if */
   return(regs.h.ch);
}
/* UM */


get_packet_info(pptr)           /* get info about the packet driver */
        struct packet_info *pptr;
{
       union REGS regs;
       struct SREGS segregs;
   if(!packet_vector)
      return(-1);
   regs.x.ax = 0x01ff;
   regs.x.bx = 0;
   int86x(packet_vector,&regs,&regs,&segregs);
   if(regs.x.cflag || regs.h.al == 0xFF)             /* shouldn't get an error getting info.. */
      return(regs.h.dh);
   pptr->packet_version = regs.x.bx;
   pptr->packet_class = regs.h.ch;
   pptr->packet_type  = regs.x.dx;
   pptr->packet_ifnumber = regs.h.cl;
   pptr->packet_name = MK_FP(segregs.ds,regs.x.si);
   pptr->packet_extended = regs.h.al == 2 ? 2 : 1;

   return(0);
}

static int
locate_pkt_vector(int vec)             /* search for the packet driver */
{
        struct mystruct {
                char far *real_vector;
        } far *vptr;
        char    far     *xvptr;
        int     vector,vmax;

        if(packet_vector)
                return(0);         /* already found!       */
        vector = 0x60;
        vmax = 0x7f;

        if((vec >= 0x60) && (vec <= 0x7f))
                vmax = vector = vec;
#ifdef CONSOLE_VERBOSE
        else
                vprint(console->vs,"Searching for Packet Driver\n\r");
#endif
        for(; vector <= vmax; vector++) {
                vptr = (struct mystruct far *) MK_FP(0,vector * 4);
                xvptr = vptr->real_vector;
                if(!strncmp(xvptr+3,"PKT DRVR",8)) {
                        packet_vector = vector;
                        return(0);
                }
        }
        return(-1);
}

int
pkt_access_type(int *handle,int if_class, int if_type, int if_number, char *type,int typelen, void (far *receiver)())

{
   union REGS regs;
   struct SREGS segregs;

   if(!packet_vector)
        return(-1);
   regs.x.ax = 2 * 256 + if_class;
   regs.x.bx = if_type;
   regs.x.dx = if_number;
   segregs.ds = FP_SEG(type);
   regs.x.si = FP_OFF(type);
   regs.x.cx = typelen;
   segregs.es = FP_SEG(receiver);
   regs.x.di = FP_OFF(receiver);
   int86x(packet_vector,&regs,&regs,&segregs);
   if(regs.x.cflag) {
        {
        char    buff[512];
        sprintf(buff,"Packet Access Type Error %d\n\r",regs.h.dh);
        vprint(console->vs,buff);

        }
        return(-1);
   }
   *handle = regs.x.ax;
   return(0);
}

int
pkt_set_rcv_mode(int handle, int mode)
{
   union REGS regs;

   if(!packet_vector)
      return(-1);
   regs.x.ax = 0x2000;
   regs.x.bx = handle;
   regs.x.cx = mode;
   int86(packet_vector,&regs,&regs);
   if(regs.x.cflag) 
      return(regs.h.dh);
   return(0);
}

void
pkt_release_type(int handle)
{
   union REGS regs;
   
   if(!packet_vector)
      return;

   regs.x.ax = 0x0300;
   regs.x.bx = handle;
   int86(packet_vector,&regs,&regs);
   return;
}

int
pkt_get_address(int handle, char *storage, int len)

{
   union REGS regs;
   struct SREGS segregs;


   if(!packet_vector)
        return;

   regs.x.ax = 0x0600;
   regs.x.bx = handle;
   regs.x.di = FP_OFF(storage);
   segregs.es = FP_SEG(storage);
   regs.x.cx = len;
   int86x(packet_vector,&regs,&regs,&segregs);
   if(regs.x.cflag) {
        char    buff[512];
        sprintf(buff,"Error retrieving address %d\n\r",regs.h.dh);
        vprint(console->vs,buff);
	 return(-1);

   }

   return(0);
}

int
pkt_xsend(char *packet, int len)
{
   union REGS regs;
   struct SREGS segregs;

   if(!packet_vector)
      return(-1);
   if(slip_mode) {
        DLAYER *h;
        h = (DLAYER *) packet;
        if(h->type != 0x8)  /* account for it already being in network order */
                return(BAD_TYPE);
        packet += sizeof(DLAYER);
        len -= sizeof(DLAYER);
   }
   regs.x.ax = 0x0400;
   regs.x.si = FP_OFF(packet);
   regs.x.cx = len;
   segregs.ds = FP_SEG(packet);
   int86x(packet_vector,&regs,&regs,&segregs);
#ifdef  XDEBUG
                { char xx[80]; 
                   sprintf(xx,"pkt_send %d bytes rc is %d (%d)\n",len, regs.h.dh, regs.x.cflag);
                   n_puts(xx);
                }
#endif

   if(regs.x.cflag)
      return(regs.h.dh);
   return(0);
}


int
pketopen(s,irq,address,ioaddr)
        char    *s;             /* ethernet address */
        int     irq;            /* don't need this      */
        int     address;        /* address is packet class */
        int     ioaddr;         /* packet int, or 0 */
                                /* we try and locate the packet driver
                                   and open ARP and IP handles.
                                */
{
   static char iptype[]={8,0};
   static char arptype[]={8,6};
   static char rarptype[] = {0x80, 0x35};
   char buff[512];
   struct packet_info p;

   if(!locate_pkt_vector(ioaddr))
           oldvec = ioaddr;
   else {
        vprint(console->vs,"No Packet Driver found.\n\r");
        return(-1);
   }
   if(have_handles)
        return(0);
   if(get_packet_info(&p)) {
        vprint(console->vs,"Packet driver returned error on driver_info call\n\r");
        return(-1);
   }
#ifdef CONSOLE_VERBOSE
   else {
        sprintf(buff,"Packet driver (%s)\n\rClass %d Type %d Version %x Extended %d\n\r",
           p.packet_name,p.packet_class,p.packet_type,p.packet_version,p.packet_extended);
        vprint(console->vs,buff);
   }
#endif

   if(address && address != p.packet_class) {
        vprint(console->vs,"Requested packet class does not match driver class\n\r");
        return(-1);
   }
   if(p.packet_class != IC_ETHERNET && p.packet_class != IC_SLIP && p.packet_class != IC_PPP) {
        vprint(console->vs,"Packet Class is neither Ethernet, Slip nor PPP. Not supported class\n\r");
        return(-1);
   }
   address = p.packet_class;
   slip_mode = (address == IC_SLIP || address == IC_PPP);
#ifdef CONSOLE_VERBOSE
   if(slip_mode) 
        vprint(console->vs,"Using Slip/PPP mode packet driver\n\r");
#endif

   if((pkt_access_type(&ip_handle,address,IT_ANY,0,iptype,slip_mode ? 0 : sizeof(iptype),pkt_receiver)) == -1) {
        sprintf(buff,"Can't Access IP handle interface type %d\n\rPacket Driver probably not loaded\n\r",address);
        vprint(console->vs,buff);
        return(-1);
   }

   if(!slip_mode) {
           if((pkt_access_type(&arp_handle,address,IT_ANY,0,arptype,sizeof(arptype),pkt_receiver)) == -1) {
                sprintf(buff,"Can't Access ARP handle\n\r");
                vprint(console->vs,buff);
                pkt_release_type(ip_handle);
                return(-1);
           }
           netgetip(buff);		/* get stored ip num */
           if (comparen(buff,"RARP",4)) {
                   rarp_mode = -1;
                   if((pkt_access_type(&rarp_handle,address,IT_ANY,0,rarptype,sizeof(rarptype),pkt_receiver)) == -1) {
                        sprintf(buff,"Can't Access RARP handle\n\r");
                        vprint(console->vs,buff);
                        pkt_release_type(ip_handle);
                        pkt_release_type(arp_handle);
                        return(-1);
                   }
           }
   }
  if(address == IC_PPP) {
	long  ip_addr;
	pkt_get_address(ip_handle, &ip_addr, sizeof(ip_addr));
	ip_addr = longswap(ip_addr);
	netsetip(&ip_addr);
  }
  else
	pkt_get_address(ip_handle,s,6);
   if(!slip_mode)
           pkt_set_rcv_mode(ip_handle,3);       /* receive broadcasts also */
   have_handles = -1;
   return(0);
}

int
pkgetaddr(s,address,ioaddr)       /* get the ethernet address */
        char    *s;             /* ethernet address */
        int     address;        /* address is packet class */
        int     ioaddr;         /* packet int, or 0 */

{
   if(!have_handles)
      return(pketopen(s,0,address,ioaddr));
   pkt_get_address(ip_handle,s,6);
   return(0);
}

void
pkrecv()                        /* no op for this interface     */
{
}

int
pketclose()                     /* throw away our handles */
{
   pkt_release_type(ip_handle);
   if(!slip_mode)
           pkt_release_type(arp_handle);
   if(rarp_mode)
           pkt_release_type(rarp_handle);
   return(0);
}

int
pkxmit(packet,length)           /* transmit a packet    */
        char    *packet;
        int     length;
{
   if((length < 60) && !slip_mode)
        length = 60;            /* what a terrible hack! */
          
   if(pkt_xsend(packet,length))
        return(-1);
   return(0);
}

unsigned pkt_es,pkt_di;

void interrupt
pkt_receiver2(unsigned bp,unsigned di,unsigned si,unsigned ds,
              unsigned es,unsigned dx,unsigned cx,unsigned bx,
              unsigned ax)
{
   char  *where_to_write;
   int   *save_packet_size;
#ifdef  XDEBUG2

   char buff[80];
   sprintf(buff,"PKTREC AX %x bx %x cx %x si %x di %x es %x\n\r",ax,bx,cx,si,di,es);
   bios_report(buff);
#endif
   /* this receiver function assumes that between the first and second call
      from the packet driver, the underlying telnet code will not access
      the buffer.
   */

   /* here's an incoming packet from the packet driver, first see if we
      have enough space for it */
   if(!ax) {
        if(bufbig+cx+sizeof(int) < buflim) {  /* if there is space remaining */
           if(bufpt > bufend)   /* if at end of wrap area then wrap it */
                bufpt = buforg;
           save_packet_size = (int *) bufpt;
           bufpt += sizeof(int);        /* we're so clean here! */
           where_to_write = bufpt;
           if(slip_mode) {
                DLAYER *h;
                where_to_write += sizeof(DLAYER);
                ax = cx;
                cx += sizeof(DLAYER);
                h = (DLAYER *) bufpt;
                h->type = 0x8;  /* force it to be type IP */
           }
           *save_packet_size = cx;
           bufpt += cx;
           bufbig += cx + sizeof(int);
           es = FP_SEG(where_to_write);
           di = FP_OFF(where_to_write);
           cx = ax;
           return;
        }
        else {
          es = di = 0;                /* no room */
        }
   }
   return;                      /* we do nothing if its the second call */
}



void
pketupdate()                    /* update the pointers */

{
   int packet_size;
   int *size_ptr;


   size_ptr = (int *) bufread;
   packet_size = *size_ptr;
   bufread += packet_size + sizeof(int);
   if(bufread > bufend)
      bufread = buforg;
   asm pushf
   asm cli                      /* inline assembly  no ints during this operation     */
   bufbig -= packet_size + sizeof(int);
   asm popf
/* asm sti */                      /* inline assembly      */
}

/* End of packet.c */
