;/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
;   Notice:
;        Portions of this file have been modified by
;        The Educational Resources Center of Clarkson University.
;
;        All modifications made by Clarkson University are hereby placed
;        in the public domain, provided the following statement remain in
;        all source files.
;
;        "Portions Developed by the Educational Resources Center, 
;                Clarkson University"
;
;        Bugs and comments to bkc@omnigate.clarkson.edu
;                                bkc@clgw.bitnet
;
;        Brad Clements
;        Educational Resources Center
;        Clarkson University
;*/


;
;  TCP/IP support routines
;****************************************************************************
;*                                                                          *
;*                                                                          *
;*      part of NCSA Telnet                                                 *
;*      by Tim Krauskopf, VT100 by Gaige Paulsen, Tek by Aaron Contorer     *
;*                                                                          *
;*      National Center for Supercomputing Applications                     *
;*      152 Computing Applications Building                                 *
;*      605 E. Springfield Ave.                                             *
;*      Champaign, IL  61820                                                *
;*                                                                          *
;****************************************************************************
;
	NAME	IPASM
	INCLUDE	DOS.MAC
	SETX

ifdef   TURBOC
	EXTRN	_netsleep:FAR	; C routine which gets called from handler
else
	EXTRN	netsleep:FAR	; C routine which gets called from handler
endif

	PSEG
ifdef   TURBOC
	PUBLIC	_ipcheck,_tcpcheck,_movebytes,_longswap,_intswap,_dbg
else
	PUBLIC	IPCHECK,TCPCHECK,MOVEBYTE,LONGSWAP,INTSWAP,DBG
endif
;
;  Routines for general use by the communications programs
;
;
;************************************************************************
;  DBG
;  provides a synch point for debugging
;
ifdef   TURBOC
_dbg	proc	far
else
dbg	proc	far
endif
	nop
nop
nop
ret
ifdef   TURBOC
_dbg endp
else
dbg endp
endif
;
;*************************************************************************
;  Internet header checksum
;    header checksum is calculated for a higher level program to verify
;
;  USAGE:  ipcheck(ptr)
;
;  this proc knows that the IP header length is found in the first byte
;
ifdef   TURBOC
begin	ipcheck
;_ipcheck	PROC	FAR
else
IPCHECK	PROC	FAR
endif
	PUSH	BP
	MOV	BP,SP
	PUSH	DS
        PUSH    SI
	MOV	AX,[BP+X+2]	; ds for input data
	MOV	DS,AX
	MOV	SI,[BP+X]	; pointer to data
	MOV	CX,[BP+X+4]	; count of words to test

	XOR	BX,BX
	CLC
CHKSUM:
	LODSW			; get next word
	ADC	BX,AX		; keep adding
	LOOP	CHKSUM		; til' done

	ADC	BX,0		; adds the carry bit in
				;
	NOT	BX		; take one more 1-complement

	MOV	AX,BX
        POP     SI
	POP	DS
	POP	BP
	RET
ifdef   TURBOC
_IPCHECK	ENDP
else
IPCHECK	ENDP
endif
;
;  TCP checksum, has two parts, including support for a pseudo-header
;
;  usage:   tcpcheck(psptr,tcpptr,tcplen)
;            char *psptr,*tcpptr;  pointers to pseudo header and real header
;            int tcplen            length of tcp packet in checksum
;

ifdef   TURBOC
;_tcpcheck	PROC	FAR
begin tcpcheck
else
TCPCHECK	PROC	FAR
endif
	PUSH	BP
	MOV	BP,SP
	PUSH	DS
        PUSH    SI
	MOV	AX,[BP+X+2]	; ds for input data for pseudo-hdr
	MOV	DS,AX
	MOV	SI,[BP+X]	; pointer to data
	MOV	CX,6		; length of p-hdr in words

	XOR	BX,BX           ; clear to begin
	CLC
PCHKSUM:
	LODSW			; get next word
	ADC	BX,AX		; keep adding
	LOOP	PCHKSUM		; til' done

	ADC	BX,0		; adds the carry bit in
;
; NOW THE REAL THING
;
	MOV	AX,[BP+X+6]	; ds of real stuff
	MOV	DS,AX
	MOV	SI,[BP+X+4]	; pointer

	MOV	CX,[BP+X+8]	; count of bytes to test
	MOV	DX,CX		; keep a copy
	SHR	CX,1		; divide by two, round down

	CLC
RCHKSUM:
	LODSW
	ADC	BX,AX		; add to previous running sum
	LOOP	RCHKSUM
	ADC	BX,0		; add the last carry in again

	AND	DX,1		; odd # of bytes?
	JZ	NOTODD
	LODSB			; get that last byte
	XOR	AH,AH		; clear the high portion
	ADD	BX,AX		; add the last one in
	ADC	BX,0		; add the carry in, too

NOTODD:
	NOT	BX		; take one more 1-complement

	MOV	AX,BX
        POP     SI
	POP	DS
	POP	BP
	RET
ifdef   TURBOC
_TCPCHECK	ENDP
else
TCPCHECK	ENDP
endif

;
;********************************************************************
;  New movebytes
;  Move an arbitrary number of bytes from one location to another.
;  Thanks to Russell Nelson for his contribution to this code.
;
;  Usage:
;  movebytes(to,from,count)
;   char *to,*from;
;   int16 count
;   moves < 64K from one 4 byte pointer to another.  Does not handle
;   overlap, but does copy quickly.
;

ifdef   TURBOC
;_movebytes      PROC	FAR
begin movebytes
else
MOVEBYTE	PROC	FAR
endif
	PUSH	BP
	MOV	BP,SP
	PUSH	DS
	PUSH	ES
        PUSH    SI
        PUSH    DI
	MOV	AX,[BP+X+2]	; WHERE TO PUT IT
	MOV	ES,AX
	MOV	AX,[BP+X+6]	; WHERE TO GET IT
	MOV	DS,AX
	MOV	SI,[BP+X+4]	; FROM PTR
	MOV	DI,[BP+X]	; TO PTR
	MOV	CX,[BP+X+8]	; HOW MANY TO MOVE

	shr cx,1		; make into a word count
	jnc dowords
	movsb			; move the odd byte
dowords:
	rep movsw

        POP     DI
        POP     SI
	POP	ES
	POP	DS
	POP	BP
	RET

ifdef   TURBOC
_MOVEBYTES	ENDP
else
MOVEBYTE	ENDP
endif

;
;*************************************************************************
;  longswap
;    swap the bytes of a long integer from PC
;  order (reverse) to in-order.  This will work both ways.
;  returns the new long value
;  usage:
;      l2 = longswap(l)
;	long l;
;
ifdef   TURBOC
;_longswap	PROC	FAR
begin longswap
else
LONGSWAP	PROC	FAR
endif
	PUSH	BP
	MOV	BP,SP
	MOV	BX,[BP+X+2]	; high bytes of the long int
	MOV	AX,[BP+X]	; low bytes of the long int
;
;  GET THE DATA
;
	XCHG	AH,AL		; SWAP THEM, these are now low
	XCHG	BH,BL		; swap the others
ifdef   TURBOC
        MOV     DX,AX           ; hi order is in DX on return
        MOV     AX,BX
endif
	POP	BP
	RET
ifdef   TURBOC
_LONGSWAP	ENDP
else
LONGSWAP	ENDP
endif

;
;*************************************************************************
;  INTSWAP
;    swap the bytes of an integer, returns the swapped integer
;
;   usage:      i = intswap(i);
;
ifdef   TURBOC
;_intswap	PROC	FAR
begin intswap
else
INTSWAP	PROC	FAR
endif
	MOV	BX,SP
	MOV	AX,SS:[BX+X-2]	; CAN IT BE DONE?
	XCHG	AH,AL
	RET
;	PUSH	BP
;	MOV	BP,SP
;	MOV	AX,[BP+X]	; GET THE INT
;	XCHG	AH,AL		; SWITCH THEM, THAT'S IT
;	POP	BP
;	RET
ifdef   TURBOC
_INTSWAP	ENDP
else
INTSWAP	ENDP
endif

;
;**************************************************************************
;
;  Routines to install and deinstall a timer routine which calls
;  netsleep(0);
;  The timer is set to go off every 1/2 second to check for packets 
;  in the incoming packet buffer.  We use the user-hook into the system 
;  timer which occurs every 1/18th of a second.
;
;
ifdef	TIMERCALL
TIMEINT	EQU	4*1CH		; User hook to timer int

ifdef   TURBOC
	PUBLIC	_TINST,_TDEINST
else
	PUBLIC	TINST,TDEINST
endif

;*************************************************************************
;
;  Take out the timer interrupt handler, restore previous value
;
ifdef   TURBOC
_tdeinst	PROC	FAR
else
TDEINST	PROC	FAR
endif
	MOV	CX,CS:TIP	; get old ip from save spot
	MOV	DX,CS:TCS	; get old cs from save spot
	MOV	BX,TIMEINT	; interrupt in table for timer
	PUSH	DS
	XOR	AX,AX		; system interrupt table
	MOV	DS,AX		
	CLI
	MOV	[BX],CX		; store old ip into the table
	INC	BX
	INC	BX		; move pointer in interrupt table
	MOV	[BX],DX		; store old cs into the table
	STI
	POP	DS
	RET
ifdef   TURBOC
_TDEINST	ENDP
else
TDEINST	ENDP
endif
;
;
;  install the timer interrupt handler, the handler is technically
;  part of this procedure.
;

ifdef   TURBOC
_tinst	PROC	FAR
else
TINST	PROC	FAR
endif
	XOR	AX,AX
	MOV	CS:TENTER,AL	; clear this flag
	MOV	CS:TMYDS,DS	; store for use by handler
	MOV	BX,TIMEINT	; interrupt in table for timer (1C)
	PUSH	DS
	XOR	AX,AX		; system interrupt table
	MOV	DS,AX		
	MOV	AX,OFFSET THAND	; where the handler is
	CLI
	MOV	DX,[BX]		; keep copy of the ip
	MOV	[BX],AX		; store ip into the table
	INC	BX
	INC	BX		; move pointer in interrupt table
	MOV	CX,[BX]		; keep copy of the cs, too
	MOV	AX,CS
	MOV	[BX],AX		; store new cs into the table
	STI
	POP	DS
	MOV	CS:TIP,DX	; store them away
	MOV	CS:TCS,CX
	RET
;
;  Code segment addressable data for keeping track of the interrupt handler
;  stuff
;
TMYDS	DW	00H		; the data segment for this assembly code
TICNT	DB	0		; counter of 1/18ths sec
TENTER DB  00
TIP  DW  00
TCS  DW  00
;
;   The handler itself.
;

THAND:			       	; not a public name, only handles ints
	STI
	PUSH	DS
	PUSH 	ES
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	CLD			; all moves will be forward
	MOV	AL,CS:TENTER
	OR	AL,AL
	JNZ	TIME2
	MOV	AL,1
	MOV	CS:TENTER,AL		; set flag to indicate busy
	INC	CS:TICNT
	MOV	AL,CS:TICNT		; counter for us
	AND	AL,7			; see if # mod 8 = 0
	JNZ	TSKIP			; skip 7 out of 8 times
;
	mov	al,60h			; EOI for timer int
	out	20h,al			; let lower interrupts in
;
;  SET UP CORRECT DS
;
	MOV	DS,CS:TMYDS	; get correct ds
;
;  do we have to set up our own stack here?
;
	xor	ax,ax
	PUSH AX
ifdef   TURBOC
	CALL _netsleep
else
	CALL netsleep
endif
	POP	AX

TSKIP:
	XOR	AL,AL
	MOV	CS:TENTER,AL		; reenter flag, done now
TIME2:
	POP SI
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POP	ES
	POP	DS
;
;   forward to any other existing routines
;
	JMP DWORD PTR CS:TIP
ifdef   TURBOC
_TINST	ENDP
else
TINST	ENDP
endif

endif
	ENDPS
	END
