/* $Id: WINDAT.H 1.5 1999/01/09 06:00:31 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/INCLUDE/RCS/WINDAT.H $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

/*
*  Windat -- window data structures for NCSA Telnet
*
*  structure to save capabilities of windows, in addition to the
*  virtual vt102 screen driver.
*/
/*  
*  terminal modes, can be changed by external program
*  VT   is a VT-only type, cannot be changed to graphics mode 
*/
#define VTTYPE 1
#define DUMBTYPE 2
#define	LOADTYPE	3
/* extra terminal states */
#define	RLOGIN		256		/* used in telstate */
#define	RSHELL		257		/* escape found */

#define NCOLORS 4

#ifndef  NTELOPTS
#include "telnet.h"
#endif

#include "newkeys.h"

struct twin {
	struct twin *next,*prev;

	unsigned short colors[NCOLORS];
	unsigned char 
		mname[16],				/* name of the machine connected to */
		linemode[82];			/* line mode buffer for session */
	int pnum,					/* port number associated */
	vs,							/* virtual screen associated with it */
	telstate,					/* telnet state for this connection */
	termstate,					/* terminal type for this connection */
	binary,						/* negotiate for binary traffic */
	igoahead,					/* negotiation for suppress go-ahead */
	ugoahead,					/* neg. for his suppress go-ahead */
	echo,						/* line mode or echo mode? */
	halfdup,					/* half duplex mode overrides line mode */
	capon,						/* does this session own a capture file? */
	sstat,						/* stat box on screen */
	bksp,						/* what keycode for backspace ?*/
	del;						/* for delete? */
        char    myopts[NTELOPTS+1];
        char    hisopts[NTELOPTS+1];
	FILE *capfp;
	long	bytes;
	long	starttime;
	KeyLib	*key_map;				/* pointer to keymap */
	unsigned int key_prefix;
	unsigned long  flags;				/* finally, a flags structure */
#define	TWIN_FLAGS_SENTANY_TYPE	  0x001	/* we sent any naws type */
#define	TWIN_FLAGS_CONFIG_PORT	  0x002	/* don't clear port number */
#define	TWIN_FLAGS_NOSHOW_PORT	  0x004	/* don't show port number */
#define	TWIN_FLAGS_RLOGIN_PORT	  0x008	/* its an RLOGIN PORT */
#define	TWIN_FLAGS_RSHELL_PORT	  0x010	/* an rshell */
#define	TWIN_FLAGS_RCMD_MASK	  0x018
#define	TWIN_FLAGS_MARGIN_BELL	  0x020	/* ring margin bell */
#define	TWIN_FLAGS_NOBINARY	  0x040	/* don't allow binary mode */
#define	TWIN_FLAGS_SCRIPT_ACTIVE  0x080	/* script file active */
#define	TWIN_FLAGS_CLOSE_NOWAIT	  0x100	/* don't do 'press a key' on close */
#define	TWIN_FLAGS_DISCARDING	  0x200	/* discarding output, until WILL_TM */

#ifdef	SCRIPT
		void	*Script;			/* ptr to script function */
#endif
};

#ifndef NPORTS
#define NPORTS  30
#endif

#ifdef WINMASTER
	struct twin *screens[30],*current=NULL,*console,*curdisp=NULL,
		*wins[NPORTS];
#else
	extern struct twin *screens[30],*current,*console,*curdisp,
		*wins[NPORTS];
#endif

/* End of windat.h */
