/*
  lxinetd.h -- INETD server for the HP200LX palmtop.

  Copyright (C) 1999  Rod Whitby

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version
  2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be 
  useful, but WITHOUT ANY WARRANTY; without even the implied
  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public
  License along with this program; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
  USA.

  $Source: A:/SRC/TCP/INETD/RCS/LXINETD.H $
  $Id: LXINETD.H 1.4 2000/04/09 07:15:52 rwhitby Exp $
*/

#include <tcp.h>

#define S_INIT 0
#define S_WAIT 1
#define S_CONN 2
#define S_CLOS 3

typedef int (*inetd_boot)(void);
typedef int (*inetd_call)(tcp_Socket *socket, void **datap);

typedef struct {
  int        status;
  tcp_Socket sockdata;
  void *     userdata;
} inetd_slot;

typedef struct {
  char *        name;
  int           port;
  inetd_boot    boot;
  inetd_call    conn;
  inetd_call    tick;
  inetd_call    quit;
  int           min_slots;
  int           max_slots;
  int           init_slots;
  int           wait_slots;
  inetd_slot ** slots;
  int           active;
} inetd_daemon;

extern byte buffer[2048];

/* End of lxinetd.h */
