#include <copyright.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tcp.h>

static void (*old_init)(char *directive, char *value);
static void new_init   (char *directive, char *value)
{
  if (!strnicmp(directive, "lxdns.", 6)) {
    strcpy(directive, directive+6);
  }
  /*fprintf(stderr, "Setting %s to %s.\n", directive, value);*/
  if (!stricmp(directive, "debug")) {
    if (atoi(value)) {
      dbug_init();
    }
    tcp_set_debug_state(atoi(value));
  }
  else {
    if (old_init) (*old_init)(directive, value);
  }
}

main(int argc, char **argv )
{
  char *name;
  char *directive, *value;
  longword host;
  int i;
  char buffer[256];

  printf("LXDNS %d.%d", VERSION/10, VERSION%10);

  if (RELEASE > 0) {
    printf("b%d", RELEASE);
  }

  printf(" - %s <%s>\n",
         "HP200LX TCP/IP Suite",
         "http://lxtcp.hplx.net/");

  old_init = usr_init;
  usr_init = new_init;

  if (getenv("LXTCP.CFG")) {
    tcp_config_file(getenv("LXTCP.CFG"));
  }

  sock_init();

  if (argc < 2) {
    puts("LXDNS hostname");
    exit(3);
  }

  for (i = 1; i < argc; i++) {
    directive = argv[i];
    if ((value = strchr(directive, '=')) != 0) {
      *value = 0; value++; strupr(directive);
      usr_init(directive, value);
    }
    else {
      name = argv[i];
    }
  }

  printf("resolving \"%s\"...", name );
  host = resolve( name );
  printf("\r");
  clreol();

  if ( host ) {
    printf("%s ", name);
    if (reverse_addr_lookup(host, buffer) &&
        strcmp(name, buffer)) {
      printf("(%s) ", buffer);
    }
    printf(": %s\n", inet_ntoa( buffer , host ));
  }
  else {
    printf("Unable to resolve %s\n", name);
  }

  return( host ? 0 : 1 );
}

/* End of lxdns.c */
